/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.entity.data.INPCMelee;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.ValueUtil;

public class DataMelee
implements INPCMelee {
    private static final int version = 1;
    private double attackRange = 2.0;
    private int attackSpeed = 20;
    private int attackStrength = 5;
    private int knockback = 0;
    private final EntityNPCInterface npc;
    private int potionAmp = 0;
    private int potionDuration = 5;
    private int potionType = 0;

    public DataMelee(EntityNPCInterface npc) {
        this.npc = npc;
    }

    @Override
    public int getDelay() {
        return this.attackSpeed;
    }

    public int getDelayRNG() {
        int delay = this.attackSpeed;
        if (this.attackSpeed < 120 && this.attackSpeed > 10) {
            delay += this.npc.field_70170_p.field_73012_v.nextInt((int)((double)this.attackSpeed * 0.15));
        }
        return delay;
    }

    @Override
    public int getEffectStrength() {
        return this.potionAmp;
    }

    @Override
    public int getEffectTime() {
        return this.potionDuration;
    }

    @Override
    public int getEffectType() {
        return this.potionType;
    }

    @Override
    public int getKnockback() {
        return this.knockback;
    }

    @Override
    public double getRange() {
        return this.attackRange;
    }

    @Override
    public int getStrength() {
        return this.attackStrength;
    }

    public void readFromNBT(NBTTagCompound compound) {
        int v;
        this.attackSpeed = compound.func_74762_e("AttackSpeed");
        this.setStrength(compound.func_74762_e("AttackStrenght"));
        this.attackRange = compound.func_150297_b("AttackRange", 3) ? (double)compound.func_74762_e("AttackRange") : compound.func_74769_h("AttackRange");
        this.knockback = compound.func_74762_e("KnockBack");
        if (1 != compound.func_74762_e("version") && (v = compound.func_74762_e("version")) < 1) {
            ++this.knockback;
        }
        this.potionType = compound.func_74762_e("PotionEffect");
        this.potionDuration = compound.func_74762_e("PotionDuration");
        this.potionAmp = compound.func_74762_e("PotionAmp");
    }

    @Override
    public void setDelay(int speed) {
        this.attackSpeed = speed;
    }

    @Override
    public void setEffect(int type, int strength, int time) {
        this.potionType = type;
        this.potionDuration = time;
        this.potionAmp = strength;
    }

    @Override
    public void setKnockback(int knockback) {
        this.knockback = knockback;
    }

    @Override
    public void setRange(double range) {
        this.attackRange = ValueUtil.correctDouble(range, 0.2, 30.0);
    }

    @Override
    public void setStrength(int strength) {
        this.attackStrength = strength;
        this.npc.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a((double)this.attackStrength);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        compound.func_74768_a("AttackStrenght", this.attackStrength);
        compound.func_74768_a("AttackSpeed", this.attackSpeed);
        compound.func_74780_a("AttackRange", this.attackRange);
        compound.func_74768_a("KnockBack", this.knockback);
        compound.func_74768_a("PotionEffect", this.potionType);
        compound.func_74768_a("PotionDuration", this.potionDuration);
        compound.func_74768_a("PotionAmp", this.potionAmp);
        compound.func_74768_a("version", 1);
        return compound;
    }
}

